<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customer_contact', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('task', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('project')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->foreign('task_id')->references('id')->on('task')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('customer_contact', function(Blueprint $table) {
			$table->dropForeign('customer_contact_customer_id_foreign');
		});
		Schema::table('project', function(Blueprint $table) {
			$table->dropForeign('project_customer_id_foreign');
		});
		Schema::table('task', function(Blueprint $table) {
			$table->dropForeign('task_task_id_foreign');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->dropForeign('user_task_user_id_foreign');
		});
		Schema::table('user_task', function(Blueprint $table) {
			$table->dropForeign('user_task_task_id_foreign');
		});
	}
}