<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNominasTable extends Migration {

	public function up()
	{
		Schema::create('nominas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->smallInteger('nomina_anio');
			$table->smallInteger('nomina_id');
			$table->smallInteger('nomina_empresa');
			$table->smallInteger('empleado_id');
			$table->smallInteger('area_id');
			$table->smallInteger('puesto_id');
			$table->smallInteger('departamento_id');
			$table->char('apellido_paterno', 40);
			$table->char('apellido_materno', 40);
			$table->char('nombre_empleado', 40);
			$table->decimal('sueldo_base_mensual');
			$table->decimal('otros_ingresos');
			$table->decimal('sueldo_quincenal');
			$table->decimal('descto_faltas');
			$table->decimal('descto_fonacot');
			$table->decimal('descto_infonavit');
			$table->decimal('otros_descuentos');
			$table->decimal('sueldo_neto');
			$table->char('cuenta_id', 20);
			$table->char('num_tarjeta_o_cta_clabe', 20);
			$table->char('banco_descripcion', 20);
			$table->char('correo_electronico', 50);
			$table->char('moneda', 10);
		});
	}

	public function down()
	{
		Schema::drop('nominas');
	}
}