<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Link extends Eloquent {

	protected $table = 'links';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function theme()
	{
		return $this->belongsTo('Theme');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag');
	}

	public function exercises()
	{
		return $this->belongsToMany('Exercise');
	}

}