<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Homework extends Eloquent {

	protected $table = 'homeworks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function exercises()
	{
		return $this->belongsToMany('Exercise');
	}

	public function group()
	{
		return $this->belongsTo('Group');
	}

	public function studentworks()
	{
		return $this->hasMany('Studentwork');
	}

}