<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Homework extends Model 
{

    protected $table = 'homeworks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function exercises()
    {
        return $this->belongsToMany('Exercise');
    }

    public function group()
    {
        return $this->belongsTo('Group');
    }

    public function studentworks()
    {
        return $this->hasMany('Studentwork');
    }

}