<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tag extends Model 
{

    protected $table = 'tags';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function exercises()
    {
        return $this->belongsToMany('Exercise');
    }

    public function links()
    {
        return $this->belongsToMany('Link');
    }

}