<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function institution()
    {
        return $this->belongsTo('Institution');
    }

    public function role()
    {
        return $this->belongsTo('Role');
    }

    public function studentworks()
    {
        return $this->hasMany('Studentwork');
    }

    public function homeworks()
    {
        return $this->hasMany('Homework');
    }

    public function groups()
    {
        return $this->hasMany('Group');
    }

    public function links()
    {
        return $this->hasMany('Link');
    }

    public function exercises()
    {
        return $this->hasMany('Exercise');
    }

    public function groupmembers()
    {
        return $this->belongsToMany('Group');
    }

}