<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('order_status')->unsigned();
			$table->string('prescription_img')->nullable();
			$table->integer('comment_id')->unsigned()->nullable();
			$table->string('allergies')->nullable();
			$table->tinyInteger('delivery_type')->default('1');
			$table->integer('counseling_id')->unsigned()->nullable()->default('0');
			$table->string('technician_media')->nullable();
			$table->integer('parent_order_id')->unsigned()->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}