<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('province_id')->references('id')->on('provinces')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->foreign('contact_method')->references('id')->on('contact_methods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('order_status')->references('id')->on('order_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('counseling_id')->references('id')->on('counselings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('drugs', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('drugs', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('refils', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('personal_consultations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('personal_consultations', function(Blueprint $table) {
			$table->foreign('comment_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_user_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_province_id_foreign');
		});
		Schema::table('user_profile', function(Blueprint $table) {
			$table->dropForeign('user_profile_contact_method_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_order_status_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_comment_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_counseling_id_foreign');
		});
		Schema::table('drugs', function(Blueprint $table) {
			$table->dropForeign('drugs_order_id_foreign');
		});
		Schema::table('drugs', function(Blueprint $table) {
			$table->dropForeign('drugs_comment_id_foreign');
		});
		Schema::table('refils', function(Blueprint $table) {
			$table->dropForeign('refils_order_id_foreign');
		});
		Schema::table('counselings', function(Blueprint $table) {
			$table->dropForeign('counselings_order_id_foreign');
		});
		Schema::table('personal_consultations', function(Blueprint $table) {
			$table->dropForeign('personal_consultations_user_id_foreign');
		});
		Schema::table('personal_consultations', function(Blueprint $table) {
			$table->dropForeign('personal_consultations_comment_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_order_id_foreign');
		});
	}
}