<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserProfileTable extends Migration {

	public function up()
	{
		Schema::create('user_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name');
			$table->string('profile_image');
			$table->date('dob')->nullable();
			$table->string('phone');
			$table->string('address_line_1')->nullable();
			$table->string('address_line_2')->nullable();
			$table->string('city')->nullable();
			$table->integer('province_id')->unsigned()->nullable();
			$table->integer('contact_method')->unsigned()->nullable();
			$table->text('allergies')->nullable();
			$table->string('insurance_front')->nullable();
			$table->string('insurance_back')->nullable();
			$table->string('idp_front')->nullable();
			$table->string('idp_back')->nullable();
			$table->string('alberta_health_care_card_front')->nullable();
			$table->string('alberta_health_care_card_back')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_profile');
	}
}