<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'User';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getRole()
    {
        return $this->hasOne('Role_User', 'user_id');
    }

    public function getUserFormation()
    {
        return $this->belongsToMany('User_Formation');
    }

    public function getUserCertification()
    {
        return $this->belongsToMany('User_Certification');
    }

    public function UserMessage()
    {
        return $this->belongsToMany('User_Message');
    }

}