<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'User';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getRole()
	{
		return $this->hasOne('Role_User', 'user_id');
	}

	public function getUserFormation()
	{
		return $this->belongsToMany('User_Formation');
	}

	public function getUserCertification()
	{
		return $this->belongsToMany('User_Certification');
	}

	public function UserMessage()
	{
		return $this->belongsToMany('User_Message');
	}

}