<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResultsTable extends Migration {

	public function up()
	{
		Schema::create('results', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('resultable_id')->unsigned();
			$table->string('resultable_type');
			$table->bigInteger('guid')->unsigned();
			$table->string('name');
			$table->string('vehicle');
			$table->integer('laps');
			$table->string('best_lap');
			$table->integer('pos');
			$table->string('gapTotal');
			$table->string('gapRelative');
			$table->string('status');
			$table->integer('points');
			$table->string('team');
			$table->timestamps();
			$table->tinyInteger('strike')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('results');
	}
}