<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('taches', function(Blueprint $table) {
			$table->foreign('positionnement_id')->references('id')->on('positionnements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->foreign('etat_id')->references('id')->on('etats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->foreign('frequence_id')->references('id')->on('frequences')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('executant_tache', function(Blueprint $table) {
			$table->foreign('executant_id')->references('id')->on('executants')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('executant_tache', function(Blueprint $table) {
			$table->foreign('tache_id')->references('id')->on('taches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poste_tache', function(Blueprint $table) {
			$table->foreign('poste_id')->references('id')->on('postes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('poste_tache', function(Blueprint $table) {
			$table->foreign('tache_id')->references('id')->on('taches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('taches', function(Blueprint $table) {
			$table->dropForeign('taches_positionnement_id_foreign');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->dropForeign('taches_etat_id_foreign');
		});
		Schema::table('taches', function(Blueprint $table) {
			$table->dropForeign('taches_frequence_id_foreign');
		});
		Schema::table('executant_tache', function(Blueprint $table) {
			$table->dropForeign('executant_tache_executant_id_foreign');
		});
		Schema::table('executant_tache', function(Blueprint $table) {
			$table->dropForeign('executant_tache_tache_id_foreign');
		});
		Schema::table('poste_tache', function(Blueprint $table) {
			$table->dropForeign('poste_tache_poste_id_foreign');
		});
		Schema::table('poste_tache', function(Blueprint $table) {
			$table->dropForeign('poste_tache_tache_id_foreign');
		});
	}
}