<?php

namespace App\Models;

class Tache extends Eloquent {

	protected $table = 'taches';
	public $timestamps = true;
	protected $fillable = array('libelle', 'description', 'infosComp', 'avantOuApres', 'dateLimite');

	public function positionnement()
	{
		return $this->belongsTo('App\Models\Positionnement');
	}

	public function frequence()
	{
		return $this->belongsTo('App\Models\Frequence');
	}

	public function etat()
	{
		return $this->belongsTo('App\Models\Etat');
	}

	public function executants()
	{
		return $this->belongsToMany('App\Models\Executant');
	}

	public function postes()
	{
		return $this->belongsToMany('App\Models\Poste');
	}

}