<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTachesoldTable extends Migration {

	public function up()
	{
		Schema::create('tachesold', function(Blueprint $table) {
			$table->increments('id');
			$table->string('libelle', 150)->nullable();
			$table->string('description', 250)->nullable();
			$table->string('infosComp', 200)->nullable();
			$table->datetime('dateLimite')->nullable();
			$table->boolean('avantOuApres')->nullable()->default(0);
			$table->integer('positionnement_id')->unsigned()->nullable();
			$table->integer('etat_id')->unsigned()->nullable()->default('3');
			$table->integer('frequence_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tachesold');
	}
}