<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name');

    public function users()
    {
        return $this->belongsToMany('User', 'user_categories', 'category_id', 'user_id');
    }

    public function questions()
    {
        return $this->belongsToMany('Models\Question', 'question_categories', 'category_id', 'question_id');
    }

    public function articles()
    {
        return $this->belongsToMany('Models\Article', 'article_categories', 'category_id', 'article_id');
    }

}