<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;
    protected $fillable = array('title', 'note');

    public function categories()
    {
        return $this->belongsToMany('Models\Category', 'question_categories', 'question_id', 'category_id');
    }

    public function users()
    {
        return $this->belongsToMany('User', 'favourites', 'question_id', 'user_id');
    }

}