<?php

namespace Models;

class Article extends Eloquent {

	protected $table = 'articles';
	public $timestamps = true;
	protected $fillable = array('title', 'note', 'image', 'type', 'user_id', 'status');

	public function categories()
	{
		return $this->belongsToMany('Models\Category', 'article_categories', 'article_id', 'category_id');
	}

	public function users()
	{
		return $this->belongsToMany('User', 'book_marks', 'article_id', 'user_id');
	}

}