<?php

namespace Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('username', 'mobile', 'email', 'image', 'experience', 'jop_description', 'birthday', 'code', 'app', 'status', 'password');

	public function categories()
	{
		return $this->belongsToMany('Models\Category', 'user_categories', 'user_id', 'category_id');
	}

	public function user_info()
	{
		return $this->belongsTo('Models\UserInfo', 'user_id');
	}

	public function questions()
	{
		return $this->belongsToMany('Models\Question', 'favourites', 'user_id', 'question_id', '');
	}

	public function articles()
	{
		return $this->belongsToMany('Models\Article', 'book_marks', 'user_id', 'article_id');
	}

}