<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArticlesTable extends Migration {

	public function up()
	{
		Schema::create('articles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 191)->nullable();
			$table->longText('note')->nullable();
			$table->string('image', 191)->nullable();
			$table->enum('type', array('admin', 'user'))->nullable();
			$table->integer('user_id')->unsigned();
			$table->enum('status', array('active', 'not_active'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('articles');
	}
}