<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestTable extends Migration {

	public function up()
	{
		Schema::create('Test', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 191);
			$table->date('date_from');
			$table->date('date_to');
			$table->json('days')->nullable();
			$table->enum('status', array('active', 'end', 'notStarted'));
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Test');
	}
}