<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeDetailsTable extends Migration {

	public function up()
	{
		Schema::create('Employee_details', function(Blueprint $table) {
			$table->increments('employee_detail_id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('employee_person_party_id')->unsigned();
			$table->string('email_id_personal', 100);
			$table->string('contact_no_personal', 20);
			$table->string('social_security_number', 12)->nullable();
			$table->string('passport_number', 20)->nullable();
			$table->string('bank_account_no');
			$table->string('bank_routing_id');
			$table->date('passport_validity_end_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('Employee_details');
	}
}