<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonFamilyRelationsTable extends Migration {

	public function up()
	{
		Schema::create('Person_Family_Relations', function(Blueprint $table) {
			$table->increments('person_family_relation_id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('person_party_id')->unsigned();
			$table->integer('family_member_party_id')->unsigned();
			$table->string('relation', 30);
		});
	}

	public function down()
	{
		Schema::drop('Person_Family_Relations');
	}
}