<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('user_id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 30);
			$table->string('password', 300);
			$table->string('confirmation_code', 300);
			$table->boolean('confirmed');
			$table->integer('role_id')->unsigned();
			$table->integer('party_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}