<?php

namespace Event;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'Event';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function times()
    {
        return $this->hasMany('Time', 'id');
    }

    public function locations()
    {
        return $this->hasMany('EventLocation', 'id');
    }

}