<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Time', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('Event')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('EventLocation', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('Event')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('EventLocation', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('Location')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Time', function(Blueprint $table) {
			$table->dropForeign('Time_event_id_foreign');
		});
		Schema::table('EventLocation', function(Blueprint $table) {
			$table->dropForeign('EventLocation_event_id_foreign');
		});
		Schema::table('EventLocation', function(Blueprint $table) {
			$table->dropForeign('EventLocation_location_id_foreign');
		});
	}
}