<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Location extends Eloquent {

	protected $table = 'Location';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('LocationCategory');
	}

	public function eventLocation()
	{
		return $this->hasMany('EventLocation', 'location_id');
	}

}