<?php

namespace Time;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Time extends Eloquent {

	protected $table = 'Time';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function event()
	{
		return $this->belongsTo('Event', 'id');
	}

	public function locations()
	{
		return $this->belongsToMany('EventLocation', 'id');
	}

}