<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGroupsTable extends Migration {

	public function up()
	{
		Schema::create('groups', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('category_id');
			$table->integer('sub_category_id');
			$table->string('group_name', 191);
			$table->string('area', area)->default('area');
			$table->string('latitude');
			$table->string('longitude');
			$table->tinyInteger('approve');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('groups');
	}
}