<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->integer('friend_id')->unsigned();
			$table->text('messages_text');
			$table->tinyInteger('is_group')->default('0');
			$table->tinyInteger('group_id')->default('0');
			$table->tinyInteger('is_service')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}