<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostAAdsTable extends Migration {

	public function up()
	{
		Schema::create('post_a_ads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned();
			$table->text('postads_text');
			$table->string('postads_img', 191)->nullable();
			$table->string('latitude', 191);
			$table->string('longitude', 191);
			$table->string('area', 191);
			$table->tinyInteger('approve')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('post_a_ads');
	}
}