<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBillsTable extends Migration {

	public function up()
	{
		Schema::create('bills', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('costumer_id');
			$table->string('name');
			$table->string('serial_number')->nullable();
			$table->string('order_number')->nullable();
			$table->timestamp('regulated_at');
			$table->timestamp('shipped_at');
			$table->integer('tax_percentage');
			$table->string('currency_code');
			$table->text('description')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('bills');
	}
}