<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function taxOffice()
	{
		return $this->belongsTo('TaxOffice');
	}

	public function bills()
	{
		return $this->hasMany('Bill');
	}

}