<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('epd_id', 255)->nullable();
			$table->string('lastname', 255);
			$table->string('lastname_prefix', 255);
			$table->string('firstnames', 255);
			$table->date('birthdate');
			$table->tinyInteger('sex');
			$table->string('email', 255);
			$table->string('telnr', 15);
			$table->string('telnr_alt', 15);
			$table->integer('address_state_id')->unsigned();
			$table->string('zipcode', 10);
			$table->string('housenumber', 10);
			$table->string('extension', 10);
			$table->string('streetname', 255);
			$table->string('city', 255);
			$table->integer('country_id')->unsigned();
			$table->text('address_alt');
			$table->integer('identification_id')->unsigned();
			$table->string('identification_nr', 255);
			$table->text('identification_alt');
			$table->string('citizen_nr', 255);
			$table->integer('marital_status_id')->unsigned();
			$table->integer('nationality_id')->unsigned();
			$table->integer('birthcountry')->unsigned();
			$table->integer('gp_agb_id');
			$table->integer('gp_state_id')->unsigned();
			$table->string('gp_name', 255);
			$table->string('gp_email', 255);
			$table->string('gp_tel', 20);
			$table->string('gp_address', 255);
			$table->string('gp_zip', 10);
			$table->string('gp_city', 255);
			$table->integer('gp_country_id')->unsigned();
			$table->integer('insurance_id')->unsigned();
			$table->integer('insurance_state_id')->unsigned();
			$table->string('insurance_nr', 255);
			$table->text('insurance_alt');
			$table->integer('insurance_country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}