<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBanksTable extends Migration {

	public function up()
	{
		Schema::create('banks', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->string('name', 255)->unique();
			$table->string('accountName', 255)->default('NULL');
			$table->string('accountNumber', 255)->unique()->default('NULL');
			$table->string('branch', 255)->nullable()->default('NULL');
			$table->string('logo', 255)->unique()->nullable()->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('banks');
	}
}