<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->string('firstName', 255)->nullable()->default('NULL');
			$table->string('lastName', 255)->nullable()->default('NULL');
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->string('phone', 255)->unique()->nullable()->default('NULL');
			$table->string('photo', 255)->unique()->nullable();
			$table->bigInteger('role')->unsigned()->nullable()->default('NULL');
			$table->string('googleID', 255)->unique()->nullable()->default('NULL');
			$table->string('linkedinID', 255)->unique()->nullable()->default('NULL');
			$table->integer('status');
			$table->string('rememberToken', 255)->unique()->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}