<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companydirectors', function(Blueprint $table) {
			$table->foreign('companyID')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companysectors', function(Blueprint $table) {
			$table->foreign('companyID')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companysectors', function(Blueprint $table) {
			$table->foreign('sectorsID')->references('id')->on('businessSectors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('companyshareholders', function(Blueprint $table) {
			$table->foreign('companyID')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('companyName')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('accountNameFrom')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('accountNumberFrom')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('bankNameFrom')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('accountNameTo')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('accountNumberTo')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->foreign('bankNameTo')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('mediaservices', function(Blueprint $table) {
			$table->foreign('orderID')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('userID')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('trackings', function(Blueprint $table) {
			$table->foreign('orderID')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('trackings', function(Blueprint $table) {
			$table->foreign('checkedBy')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companydirectors', function(Blueprint $table) {
			$table->dropForeign('companydirectors_companyID_foreign');
		});
		Schema::table('companysectors', function(Blueprint $table) {
			$table->dropForeign('companysectors_companyID_foreign');
		});
		Schema::table('companysectors', function(Blueprint $table) {
			$table->dropForeign('companysectors_sectorsID_foreign');
		});
		Schema::table('companyshareholders', function(Blueprint $table) {
			$table->dropForeign('companyshareholders_companyID_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_companyName_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_accountNameFrom_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_accountNumberFrom_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_bankNameFrom_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_accountNameTo_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_accountNumberTo_foreign');
		});
		Schema::table('confirmations', function(Blueprint $table) {
			$table->dropForeign('confirmations_bankNameTo_foreign');
		});
		Schema::table('mediaservices', function(Blueprint $table) {
			$table->dropForeign('mediaservices_orderID_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_userID_foreign');
		});
		Schema::table('trackings', function(Blueprint $table) {
			$table->dropForeign('trackings_orderID_foreign');
		});
		Schema::table('trackings', function(Blueprint $table) {
			$table->dropForeign('trackings_checkedBy_foreign');
		});
	}
}