<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->integer('userID')->unsigned();
			$table->tinyInteger('isPurchaseVirtualAddress')->default('NULL');
			$table->integer('totalPrice');
			$table->string('paymentMethod', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}