<?php

namespace models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'bdate', 'blood_type_id', 'last_donate_date', 'city_id', 'phone', 'password');

    public function BloodType()
    {
        return $this->belongsTo('models\BloodType');
    }

    public function City()
    {
        return $this->belongsTo('models\City', 'city_id');
    }

    public function Posts()
    {
        return $this->hasMany('models\Post', 'client_id');
    }

    public function FavourPosts()
    {
        return $this->belongsToMany('models\Post', 'post_id');
    }

    public function ContactUsMessages()
    {
        return $this->hasMany('models\ContactUsMessage', 'client_id');
    }

    public function DonationOrders()
    {
        return $this->hasMany('models\Client', 'client_id');
    }

    public function Notifications()
    {
        return $this->belongsToMany('models\Notifications');
    }

    public function BloodTypes()
    {
        return $this->belongsToMany('models\BloodType');
    }

    public function Governorates()
    {
        return $this->belongsToMany('models\Governorates');
    }

}