<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationOrdersTable extends Migration {

	public function up()
	{
		Schema::create('donation_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->integer('age');
			$table->integer('blood_count');
			$table->string('hospital_address', 255);
			$table->string('phone', 255);
			$table->text('notes');
			$table->integer('city_id')->unsigned();
			$table->integer('blood_type_id')->unsigned();
			$table->integer('client_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('donation_orders');
	}
}