<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Blog_Post extends Eloquent {

	protected $table = 'blog_posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id');

	public function blog_category()
	{
		return $this->hasOne('Blog_Category');
	}

	public function blog_comments()
	{
		return $this->hasMany('Blog_Comment');
	}

	public function blog_post_tags()
	{
		return $this->belongsToMany('Blog_Post_Tag');
	}

}