<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuTable extends Migration {

	public function up()
	{
		Schema::create('menu', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('entity_type')->nullable();
			$table->integer('entity_id')->nullable();
			$table->string('title', 191);
			$table->string('slug', 191);
			$table->string('base_url', 191)->nullable();
			$table->integer('parent_id')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('menu');
	}
}