<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIndexsTable extends Migration {

	public function up()
	{
		Schema::create('indexs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('offer_id');
			$table->string('offer_title', 256);
			$table->text('offer_text')->nullable();
			$table->text('offer_description')->nullable();
			$table->tinyInteger('offer_type')->default('0');
			$table->string('offer_coupon', 256)->nullable();
			$table->string('offer_image_url', 256)->nullable();
			$table->string('offer_featured', 256)->nullable();
			$table->string('offer_value', 256)->nullable();
			$table->text('offer_long_url');
			$table->string('offer_short_url_code', 256)->unique();
			$table->text('terms_and_conditions')->nullable();
			$table->date('offer_start_date');
			$table->date('offer_end_date');
			$table->text('offer_copy_json');
			$table->timestamps();
			$table->tinyInteger('offer_status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('indexs');
	}
}