<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCandidatesTable extends Migration {

	public function up()
	{
		Schema::create('candidates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->integer('status');
			$table->string('address', 250);
			$table->integer('country')->unsigned();
			$table->integer('state')->unsigned();
			$table->integer('city')->unsigned();
			$table->string('email', 300);
			$table->bigInteger('phone');
			$table->integer('party')->unsigned();
			$table->date('date_of_birth');
		});
	}

	public function down()
	{
		Schema::drop('candidates');
	}
}