<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('country')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('state')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('city')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->foreign('party')->references('id')->on('parties')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('election_polling_areas', function(Blueprint $table) {
			$table->foreign('election_id')->references('id')->on('elections')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('election_polling_areas', function(Blueprint $table) {
			$table->foreign('polling_area_id')->references('id')->on('polling_areas')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_country_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_state_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_city_foreign');
		});
		Schema::table('candidates', function(Blueprint $table) {
			$table->dropForeign('candidates_party_foreign');
		});
		Schema::table('election_polling_areas', function(Blueprint $table) {
			$table->dropForeign('election_polling_areas_election_id_foreign');
		});
		Schema::table('election_polling_areas', function(Blueprint $table) {
			$table->dropForeign('election_polling_areas_polling_area_id_foreign');
		});
	}
}