<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CandidatePolliingArea extends Eloquent {

	protected $table = 'candidate_polling_areas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('election_polling_area_id');

	public function polling()
	{
		return $this->belongsTo('ElectionPollingArea', 'polling_area_id');
	}

	public function candidate()
	{
		return $this->belongsTo('Model\Candidate', 'candidate_id');
	}

}