<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Election extends Eloquent {

	protected $table = 'elections';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'election_type', 'start_date_time', 'email', 'phone', 'description', 'status');

	public function election_area()
	{
		return $this->hasMany('Model\ElectionPollingArea', 'election_id');
	}

	public function election_type()
	{
		return $this->belongsTo('Model\ElectionType', 'election_type');
	}

}