<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PollingArea extends Eloquent {

	protected $table = 'polling_areas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'location', 'country', 'state', 'city');

	public function voter_detail()
	{
		return $this->hasMany('Model\VoterDetail', 'voter_area_id');
	}

	public function election()
	{
		return $this->hasMany('Model\ElectionPollingArea', 'polling_area_id');
	}

	public function voter_file()
	{
		return $this->hasMany('Model\VoterFile', 'polling_area_id');
	}

	public function sms()
	{
		return $this->hasMany('Model\VoterSms', 'polling_area_id');
	}

}