<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class VoterDetail extends Eloquent {

	protected $table = 'voter_details';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('voter_area_id', 'name', 'voucher_id', 'phone', 'email');

	public function area()
	{
		return $this->belongsTo('Model\PollingArea', 'voter_area_id');
	}

}